<?php
require_once __DIR__ . '/../includes/config.php';
if (!IG_ENABLED) return;

$url = "https://graph.facebook.com/v19.0/" . urlencode(IG_USER_ID)
     . "/media?fields=id,caption,media_type,media_url,permalink,thumbnail_url,timestamp"
     . "&limit=" . intval(IG_LIMIT)
     . "&access_token=" . urlencode(IG_ACCESS_TOKEN);

$ch = curl_init($url);
curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
$res = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http !== 200 || !$res) { echo '<p class="help">Instagram indisponível (token/permissões).</p>'; return; }

$data = json_decode($res, true);
$items = $data['data'] ?? [];
if (!$items) return;

echo '<div class="grid3" style="margin-top:10px">';
foreach ($items as $it) {
  $img = $it['media_url'] ?? ($it['thumbnail_url'] ?? '');
  if (!$img) continue;
  $cap = $it['caption'] ?? '';
  $link = $it['permalink'] ?? '#';
  echo '<a class="card svc" href="'.htmlspecialchars($link).'" target="_blank" rel="noopener">';
  echo '<img src="'.htmlspecialchars($img).'" alt="">';
  echo '<div class="pad"><div class="d">'.htmlspecialchars(mb_strimwidth($cap, 0, 120, '…')).'</div></div>';
  echo '</a>';
}
echo '</div>';
