<?php require_once __DIR__ . '/config.php';
require_once __DIR__ . '/helpers.php'; ?>
<!doctype html>
<html lang="pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? SITE_NAME) ?></title>
  <meta name="description" content="<?= htmlspecialchars(SITE_TAGLINE . ' — ' . SITE_AREA) ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<header class="topbar">
  <div class="container bar">
    <a class="brand" href="./">
      <img src="assets/img/logo.svg" alt="<?= htmlspecialchars(SITE_NAME) ?>">
      <div>
        <div class="name"><?= htmlspecialchars(SITE_NAME) ?></div>
        <div class="tag"><?= htmlspecialchars(SITE_TAGLINE) ?></div>
      </div>
    </a>

    <nav class="nav">
      <a href="servicos.php">Serviços</a>
      <a href="portfolio.php">Portfólio</a>
      <a href="novidades.php">Novidades</a>
      <a class="btn" href="contacto.php">Pedir orçamento</a>
    </nav>
  </div>
</header>
<main>
