<?php
$title = 'Contacto — ProntoAjuste Caldas';
require_once __DIR__ . '/includes/config.php';

$errors = [];
$values = [
  'servico' => $_POST['servico'] ?? '',
  'local'   => trim($_POST['local'] ?? ''),
  'nome'    => trim($_POST['nome'] ?? ''),
  'contacto'=> trim($_POST['contacto'] ?? ''),
  'mensagem'=> trim($_POST['mensagem'] ?? ''),
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $allowed = ['electricidade','canalizacoes','pinturas','outro'];
  if (!in_array($values['servico'], $allowed, true)) $errors[] = 'Selecione o tipo de serviço.';
  if (mb_strlen($values['local']) < 3) $errors[] = 'Indique o local do serviço (ex: freguesia/rua).';
  if (mb_strlen($values['nome']) < 2) $errors[] = 'Indique o seu nome.';
  if (mb_strlen($values['contacto']) < 6) $errors[] = 'Indique um contacto (telemóvel ou email).';

  if (!$errors) {
    $subject = '[' . SITE_NAME . '] Pedido de orçamento (' . $values['servico'] . ')';
    $body = "Novo pedido de contacto\n\n"
      . "Serviço: {$values['servico']}\n"
      . "Local: {$values['local']}\n"
      . "Nome: {$values['nome']}\n"
      . "Contacto: {$values['contacto']}\n"
      . "Mensagem: {$values['mensagem']}\n"
      . "IP: " . ($_SERVER['REMOTE_ADDR'] ?? '') . "\n";

    $headers = [];
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-type: text/plain; charset=utf-8';
    $headers[] = 'From: ' . CONTACT_FROM_EMAIL;
    $headers[] = 'Reply-To: ' . $values['contacto'];

    $ok = @mail(CONTACT_TO_EMAIL, '=?UTF-8?B?' . base64_encode($subject) . '?=', $body, implode("\r\n", $headers));

    if ($ok) {
      header('Location: obrigado.php');
      exit;
    } else {
      $errors[] = 'Não foi possível enviar por mail() neste servidor. Configure SMTP (recomendado) ou fale com o seu hosting.';
    }
  }
}

include __DIR__ . '/includes/header.php';
?>
<section class="section">
  <div class="container">
    <div class="card">
      <h2 style="margin:0 0 10px">Pedir orçamento</h2>
      <p class="muted">Diga o que precisa e onde — eu respondo com disponibilidade e estimativa.</p>

      <?php if ($errors): ?>
        <div class="card" style="border-color:#7a2b2b">
          <b>Corrija:</b>
          <ul class="muted">
            <?php foreach ($errors as $e): ?>
              <li><?= htmlspecialchars($e) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <form class="form" method="post" action="contacto.php" novalidate>
        <label for="servico">Tipo de serviço</label>
        <select id="servico" name="servico" required>
          <option value="">— Selecionar —</option>
          <option value="electricidade" <?= $values['servico']==='electricidade'?'selected':'' ?>>Electricidade</option>
          <option value="canalizacoes" <?= $values['servico']==='canalizacoes'?'selected':'' ?>>Canalizações</option>
          <option value="pinturas" <?= $values['servico']==='pinturas'?'selected':'' ?>>Pinturas</option>
          <option value="outro" <?= $values['servico']==='outro'?'selected':'' ?>>Outro</option>
        </select>

        <label for="local">Local do serviço</label>
        <input id="local" name="local" placeholder="Ex: Caldas da Rainha, Foz do Arelho, etc." value="<?= htmlspecialchars($values['local']) ?>" required>

        <label for="nome">Nome</label>
        <input id="nome" name="nome" placeholder="O seu nome" value="<?= htmlspecialchars($values['nome']) ?>" required>

        <label for="contacto">Contacto</label>
        <input id="contacto" name="contacto" placeholder="Telemóvel ou email" value="<?= htmlspecialchars($values['contacto']) ?>" required>

        <label for="mensagem">Detalhes (opcional)</label>
        <textarea id="mensagem" name="mensagem" placeholder="Ex: 'torneira a pingar na cozinha', 'trocar 2 interruptores'..."><?= htmlspecialchars($values['mensagem']) ?></textarea>

        <div style="margin-top:12px">
          <button class="btn" type="submit">Enviar pedido</button>
          <span class="help">Ao enviar, aceita ser contactado para resposta ao pedido.</span>
        </div>
      </form>
    </div>
  </div>
</section>
<?php include __DIR__ . '/includes/footer.php'; ?>
