<?php
require_once __DIR__ . '/../includes/config.php';

if (!FB_ENABLED) return;

$url = "https://graph.facebook.com/v19.0/" . urlencode(FB_PAGE_ID)
     . "/posts?fields=message,permalink_url,created_time"
     . "&limit=" . intval(FB_LIMIT)
     . "&access_token=" . urlencode(FB_PAGE_ACCESS_TOKEN);

$ch = curl_init($url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_TIMEOUT => 10,
]);
$res = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http !== 200 || !$res) {
  echo '<p class="help">Facebook feed indisponível (verifique token/permissões).</p>';
  return;
}

$data = json_decode($res, true);
$items = $data['data'] ?? [];
if (!$items) return;

echo '<hr><div style="margin-top:10px">';
echo '<div class="muted" style="font-weight:700;margin-bottom:8px">Facebook</div>';
foreach ($items as $it) {
  $msg = $it['message'] ?? '';
  $link = $it['permalink_url'] ?? '#';
  echo '<div class="card" style="padding:12px;margin-bottom:10px">';
  echo '<div class="muted">'.htmlspecialchars(mb_strimwidth($msg, 0, 180, '…')).'</div>';
  echo '<div style="margin-top:8px"><a class="btn" href="'.htmlspecialchars($link).'" target="_blank" rel="noopener">Ver publicação</a></div>';
  echo '</div>';
}
echo '</div>';
