<?php
// Debug mode: abra /reparos/?debug=1 para ver erros (desligue depois)
if (isset($_GET['debug'])) {
  ini_set('display_errors', '1');
  ini_set('display_startup_errors', '1');
  error_reporting(E_ALL);

  register_shutdown_function(function () {
    $e = error_get_last();
    if ($e && in_array($e['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR], true)) {
      echo "<pre style='white-space:pre-wrap;background:#fff1f2;border:1px solid #fecaca;padding:12px;border-radius:12px'>";
      echo "FATAL: {$e['message']}\n{$e['file']}:{$e['line']}";
      echo "</pre>";
    }
  });
}
?>
<?php require_once __DIR__ . '/config.php';
require_once __DIR__ . '/helpers.php'; ?>
<!doctype html>
<html lang="pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? SITE_NAME) ?></title>
  <meta name="description" content="<?= htmlspecialchars(SITE_TAGLINE . ' — ' . SITE_AREA) ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<header class="topbar">
  <div class="container bar">
    <a class="brand" href="./">
      <img src="assets/img/logo.svg" alt="<?= htmlspecialchars(SITE_NAME) ?>">
      <div>
        <div class="name"><?= htmlspecialchars(SITE_NAME) ?></div>
        <div class="tag"><?= htmlspecialchars(SITE_TAGLINE) ?></div>
      </div>
    </a>

    <nav class="nav">
      <a href="servicos.php">Serviços</a>
      <a href="portfolio.php">Portfólio</a>
      <a href="novidades.php">Novidades</a>
      <a class="btn" href="contacto.php">Pedir orçamento</a>
    </nav>
  </div>
</header>
<main>
