<?php
require_once __DIR__ . '/includes/config.php';
$title = SITE_NAME . ' — Reparos ao Domicílio';
include __DIR__ . '/includes/header.php';
?>
<section class="hero">
  <div class="container hero-grid">
    <div class="card pad">
      <h1 class="h1">Reparos rápidos em casa,<br>com acabamento profissional.</h1>
      <p class="lead"><?= htmlspecialchars(SITE_TAGLINE) ?> no <?= htmlspecialchars(SITE_AREA) ?>.</p>

      <div class="pills">
        <div class="pill"><span class="dot"></span>Deslocação local</div>
        <div class="pill"><span class="dot"></span>Trabalho limpo</div>
        <div class="pill"><span class="dot"></span>Orçamento por mensagem</div>
      </div>

      <div style="display:flex;gap:10px;flex-wrap:wrap">
        <a class="btn" href="contacto.php">Pedir orçamento</a>
        <a class="btn secondary" href="servicos.php">Ver serviços</a>
      </div>

      <hr class="hr">
      <div class="grid2">
        <div class="card pad" style="box-shadow:none;background:transparent;border:0;padding:0">
          <div class="kpi"><div style="width:12px;height:12px;border-radius:99px;background:var(--accent);margin-top:6px"></div>
            <div><b>Electricidade</b><span>tomadas, iluminação, pequenos diagnósticos</span></div>
          </div>
        </div>
        <div class="card pad" style="box-shadow:none;background:transparent;border:0;padding:0">
          <div class="kpi"><div style="width:12px;height:12px;border-radius:99px;background:var(--accent);margin-top:6px"></div>
            <div><b>Canalizações</b><span>torneiras, sifões, fugas simples</span></div>
          </div>
        </div>
      </div>
    </div>

    <div class="card media" aria-hidden="true">
      <img src="assets/img/hero.jpg" alt="">
    </div>
  </div>
</section>

<section class="section">
  <div class="container">
    <div class="grid2">
      <div class="card svc">
        <img src="assets/img/electricidade.jpg" alt="Electricidade">
        <div class="pad">
          <div class="t">Electricidade</div>
          <p class="d">Substituição de tomadas/interruptores, instalação de luminárias e resolução de falhas simples.</p>
          <div style="margin-top:12px"><a class="btn secondary" href="servicos.php#electricidade">Detalhes</a></div>
        </div>
      </div>

      <div class="card svc">
        <img src="assets/img/canalizacoes.jpg" alt="Canalizações">
        <div class="pad">
          <div class="t">Canalizações</div>
          <p class="d">Troca de torneiras, sifões, vedações e pequenas fugas — rápido e sem complicações.</p>
          <div style="margin-top:12px"><a class="btn secondary" href="servicos.php#canalizacoes">Detalhes</a></div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section">
  <div class="container">
    <div class="card pad">
      <div style="display:flex;align-items:flex-end;justify-content:space-between;gap:14px;flex-wrap:wrap">
        <div>
          <div style="font-weight:950;font-size:18px">Novidades nas redes</div>
          <p class="help" style="margin:6px 0 0">Pode ligar feeds do Instagram/Facebook (opcional).</p>
        </div>
        <a class="btn secondary" href="novidades.php">Ver novidades</a>
      </div>

      <?php include __DIR__ . '/api/instagram_feed.php'; ?>
      <?php include __DIR__ . '/api/facebook_feed.php'; ?>

      <?php if (!IG_ENABLED && !FB_ENABLED): ?>
        <p class="help" style="margin-top:12px">Feeds desligados. Ative em <code>includes/config.php</code>.</p>
      <?php endif; ?>
    </div>
  </div>
</section>

<?php include __DIR__ . '/includes/footer.php'; ?>
